% Slavko Moconja, Matematicki fakultet 47/03
function [x, g] = ResiSistem(A, b)

% vracamo uputstvo za koriscenje programa, ako je unet
% neodgovarajuc broj argumenata
if nargin ~= 2
    error 'Uputstvo: Unesite matricu sistema i vektor slobodnih clanova'
end

% proveravamo da li je vektor b kolona
[k, l] = size( b );
if k == 1 & l ~= 1
    disp( 'Vektor b je vrsta, pa ga transponujemo!!!' )
    b = b';
end

% trazimo coleski dekompoziciju f.jama Coleski i chol
L = Coleski( A );
Lp = chol( A )';
L-Lp

% resavamo trougaone sisteme j.na
y = DonjeTrougaoniSistem( L, b );
x = GornjeTrougaoniSistem( L', y );

yp = DonjeTrougaoniSistem( Lp, b );
xp = GornjeTrougaoniSistem( Lp', yp );

% x je resenje koje je u potpunosti implementirano,
% a xp je resenje nadjeno pomocu ugradjene f.je
% zato vracamo i normu razlike ova dva resenja
g = norm(x-xp);